local main_loop = loadfile("squirrelscripts/main_ai_loop.nut");
dofile("squirrelscripts/ai_functions.nut");

function init() {
	rem_cut_scene_on <- false;
	rem_ships_at_conf_dead <- false;
	timer <- 1000;
}

function run_ai() {
	local frame_counter = world_frame_counter();
	if (is_cut_scene_on())
		return;
		
	if (!rem_cut_scene_on) {
		my_squads[37].select();
		order_move(18243, 6834);
		
		my_squads[38].select();
		order_move(17403, 7354);
		
		rem_cut_scene_on = true;
		return;
	}
	
	if (!rem_ships_at_conf_dead) {
		if (my_squads.len() <= 25) {
			wakeup_mission_script(0);
			rem_ships_at_conf_dead = true;
		}
		return;
	}
	
	check_for_launch_defence();

	if (world_frame_counter() > timer) {
		local player_pos = is_player_squad_close("big_ship", 10500);
		//only launch attacks when they get close
		if (player_pos) {
			launch_attack_wave(player_pos, 1);
			//1 minute
			timer = world_frame_counter() + 1800;
		}
	}
}

main_loop();
